(*--------------------------------------------------------------------**
**	    	Fa. MAMAvision Software Consult                             **
**		    Wollmatingerstrae 70b  D-78467 Konstanz	                  **
**	      Tel.: (07531)690014     Fax: (07531)690015                  **
**--Projekt-----------------------------------------------------------**
**		                  HPGL-Viewer/Printer                           **
**                     SOFTWARE\HPGL\PAS\....                         **
**--Revisionhistory---------------------------------------------------**
**
lgb
    Tslider renamed to TTrackbar in Unit ComCtrls for 32compatibility
lge
**
**--Module------------------------------------------------------------**
**  Modul-Name      : modname: Settings.pas
**  Modul-Revision  : version: 1.0
**  Projekt-Revision: 1.0
**--------------------------------------------------------------------**
nokeywords
**--------------------------------------------------------------------*)
unit Settings;
(*--------------------------------------------------------------------*)
(*		          													                            *)
(*	 Small Demo Application to demonstrate TMMPlot Component          *)
(*		          													                            *)
(*--------------------------------------------------------------------*)
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Buttons, ExtCtrls, MMPlot_U,
  Comctrls;

type
  TSettingsDlg = class(TForm)
    Notebook: TTabbedNotebook;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Panel1: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    Panel2: TPanel;
    PanelBkGnd: TPanel;
    ColorDialog: TColorDialog;
    Panel6: TPanel;
    StdBtn: TBitBtn;
    Bevel3: TBevel;
    cbSaveSet: TCheckBox;
    cbShowTB: TCheckBox;
    cbShowNAV: TCheckBox;
    cbAutoStretch: TCheckBox;
    Panel9: TPanel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    DLLName: TLabel;
    DLLCopyright: TLabel;
    DLLVersion: TLabel;
    Label14: TLabel;
    Bevel2: TBevel;
    Slider: TTrackbar;
    procedure PanelEnter(Sender: TObject);
    procedure PanelExit(Sender: TObject);
    procedure PanelClick(Sender: TObject);
    procedure PanelDblClick(Sender: TObject);
    procedure SliderValueChange(Sender: TObject);
    procedure StdBtnClick(Sender: TObject);
    procedure NotebookChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    Panel: TPanel;
    procedure GetAbout;
    procedure GetPens;
    procedure SetPens;
    procedure SetDesktop;
    procedure GetDesktop;
  public
    { Public declarations }
    procedure SetPanels;
    procedure  GetPanels;
  end;

var
  SettingsDlg: TSettingsDlg;

implementation

{$R *.DFM}
uses Main;

procedure TSettingsDlg.SetPanels;
begin
  Panel1.Color := MainForm.MMPlot1.PenColor[1];
  Panel2.Color := MainForm.MMPlot1.PenColor[2];
  Panel3.Color := MainForm.MMPlot1.PenColor[3];
  Panel4.Color := MainForm.MMPlot1.PenColor[4];
  Panel5.Color := MainForm.MMPlot1.PenColor[5];
  Panel6.Color := MainForm.MMPlot1.PenColor[6];
  Panel7.Color := MainForm.MMPlot1.PenColor[7];
  Panel8.Color := MainForm.MMPlot1.PenColor[8];
end;

procedure TSettingsDlg.GetPanels;
begin
  MainForm.MMPlot1.PenColor[1] := Panel1.Color;
  MainForm.MMPlot1.PenColor[2] := Panel2.Color;
  MainForm.MMPlot1.PenColor[3] := Panel3.Color;
  MainForm.MMPlot1.PenColor[4] := Panel4.Color;
  MainForm.MMPlot1.PenColor[5] := Panel5.Color;
  MainForm.MMPlot1.PenColor[6] := Panel6.Color;
  MainForm.MMPlot1.PenColor[7] := Panel7.Color;
  MainForm.MMPlot1.PenColor[8] := Panel8.Color;
end;

procedure TSettingsDlg.PanelEnter(Sender: TObject);
begin
  TObject(Panel) := Sender;
  Panel.borderstyle := bssingle;
end;

procedure TSettingsDlg.PanelExit(Sender: TObject);
begin
  Panel.borderstyle := bsnone;
end;

procedure TSettingsDlg.PanelClick(Sender: TObject);
begin
  TPanel(Sender).SetFocus;
end;

procedure TSettingsDlg.PanelDblClick(Sender: TObject);
begin
  Colordialog.Color := TPanel(Sender).Color;
  if Colordialog.Execute then
    TPanel(Sender).Color := Colordialog.Color;
end;

procedure TSettingsDlg.SliderValueChange(Sender: TObject);
begin
{$ifndef WIN32}
  Slider.Trackwidth := Slider.Position+2;
{$endif}
end;

procedure TSettingsDlg.StdBtnClick(Sender: TObject);
begin
  Case Notebook.Pageindex of
  0: begin
      cbSaveSet.checked := true;
      cbShowTB.checked := true;
      cbShowNAV.checked := true;
      cbAutoStretch.checked := true;
    end;
  1: begin
      MainForm.MMPlot1.SetACADPal_9;
      SetPanels;
      PanelBkGnd.Color := clBtnFace;
      Slider.Position := 4;
    end;
  2: begin
    end;
  end;
end;

procedure TSettingsDlg.NotebookChange(Sender: TObject;
  NewTab: Integer; var AllowChange: Boolean);
begin
  StdBtn.Visible := NewTab < 2;
  AllowChange := true;
end;

procedure TSettingsDlg.FormCreate(Sender: TObject);
begin
  GetPens;
end;

procedure TSettingsDlg.SetPens;
begin
  GetPanels;
  MainForm.Color := PanelBkGnd.Color;
  MainForm.MMPlot1.Penfactor := Slider.position;
end;

procedure TSettingsDlg.SetDesktop;
begin
  MainForm.DragPanel.visible := cbShowNav.Checked;
  MainForm.Speedbar.visible  := cbShowTB.Checked;
  MainForm.Autostretch := cbAutoStretch.Checked;
end;

procedure TSettingsDlg.GetAbout;
begin
  Version.Caption := 'Rev.'+MainForm.MMPLot1.Version;
  DLLVersion.Caption := 'Rev.'+MMPlot_U.GetDLLVersion;
End;

procedure TSettingsDlg.GetPens;
begin
  SetPanels;
  PanelBkGnd.Color := MainForm.Color;
  Slider.position := MainForm.PaintBox1.Canvas.Pen.Width;
End;

procedure TSettingsDlg.GetDesktop;
begin
  cbShowNav.Checked := MainForm.DragPanel.visible;
  cbShowTB.Checked := MainForm.Speedbar.visible;
  cbAutoStretch.Checked := MainForm.Autostretch;
end;

procedure TSettingsDlg.OKBtnClick(Sender: TObject);
begin
  SetPens;
  SetDesktop;
end;

procedure TSettingsDlg.FormActivate(Sender: TObject);
begin
  StdBtn.Visible := Notebook.pageindex < 2;
  GetDesktop;
  GetAbout;
end;

procedure TSettingsDlg.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  If cbSaveSet.Checked then;
     { save it }
end;

end.
